/**
* \file: VrTtsAudioChannel.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* Sample audio channel implementation for voice recognition text to speech
*
* \component: Baidu CarLife
*
* \author: P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <string>
#include <adit_logging.h>
#include <bdcl/AilAudioSink.h>
#include "VrTtsAudioChannel.h"

LOG_IMPORT_CONTEXT(tbdcl)

// todo check return values of the calles methods

namespace adit { namespace bdcl {

// todo replace raw ptr with smart ptr
VrTtsAudioChannel::VrTtsAudioChannel(CoreCallbackDealer* inCallbackDealer)
{
    mAudioSink = new AilAudioSink(this, inCallbackDealer);
    isVrInterrupted = false;
    /* set config items */
    mAudioSink->setConfigItem("audio-playback-device", "device=interrupt periodms=8 inittoutms=2000");
    mAudioSink->setConfigItem("audio-sink-stream-type", "AUDIO_STREAM_VR_TTS");
    mAudioSink->setConfigItem("audio-sink-threshold-ms", "100");
    mAudioSink->setConfigItem("audio-sink-buffer-max-ms", "14000");
    mAudioSink->setConfigItem("disable-real-time-priority-audio", "0");
    mAudioSink->setConfigItem("audio-threads-real-time-priority", "61");
    mAudioSink->setConfigItem("audio-sink-channels", "1");
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", "16");
    mAudioSink->setConfigItem("audio-sink-sampling-rate", "16000");

    mAudioSink->initialize();
}

VrTtsAudioChannel::~VrTtsAudioChannel()
{
    mAudioSink->teardown();
    delete mAudioSink;
}

void VrTtsAudioChannel::onPlaybackInit(unsigned int inSampleRate, unsigned int inChannelConfig, unsigned int inSampleFormat)
{
    mAudioSink->setConfigItem("audio-sink-sampling-rate", std::to_string(inSampleRate));
    mAudioSink->setConfigItem("audio-sink-channels", std::to_string(inChannelConfig));
    mAudioSink->setConfigItem("audio-sink-bits-per-sample", std::to_string(inSampleFormat));
    isVrInterrupted = false;
    mAudioSink->initialize();

    mAudioSink->playbackStart();
}

void VrTtsAudioChannel::onPlaybackStop()
{
    //todo VR_STOP and VR_INTERRUPT messages are processed sequentially in our demo implementation.
    // above two messages has to be handled parallely then the below conditions will work. currently its always mAudioSink->playbackStop(false)

    if(isVrInterrupted){
        LOGD_DEBUG((tbdcl, "%s initiated flushing the buffer", __FUNCTION__));
        mAudioSink->playbackStop(true);
    }else{
        LOGD_DEBUG((tbdcl, "%s initiated without flushing the buffer", __FUNCTION__));
        mAudioSink->playbackStop(false);
    }
    isVrInterrupted = false;
}

void VrTtsAudioChannel::onPlaybackInterrupt()
{
    // todo implement logic, which has compatibility issues with the current state machine because MD is sending the
    // interrupt message in an unexpected sequence.
    isVrInterrupted = true;
    LOGD_DEBUG((tbdcl, "%s initiated", __PRETTY_FUNCTION__));
}

void VrTtsAudioChannel::onError(bdclErrorCodes inErrorCode)
{
    LOG_ERROR((tbdcl, "Error: %d on VR TTS audio channel", static_cast<uint32_t>(inErrorCode)));
}

} } /* namespace adit { namespace bdcl */
